#!/bin/bash
# This command creates a .pem SSL Certificate in /private/tmp.

cd /private/tmp

cat <<END >/private/tmp/SSL_Certificate.crt
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
END

# This command installs the SSL Cert as trusted in the macOS System Keychain

sudo security add-trusted-cert -d -r trustRoot -k "/Library/Keychains/System.keychain" "/private/tmp/SSL_Certificate.crt"


# The following code makes Firefox trust the macOS Keychain certificates if Firefox is installed.

if [ -d /Applications/Firefox.app ] && [ ! -e /Applications/Firefox.app/Contents/Resources/distribution/policies.json ]; 

then

mkdir -p /Applications/Firefox.app/Contents/Resources/distribution
cat <<END >/Applications/Firefox.app/Contents/Resources/distribution/policies.json
{
  "policies": {
    "Certificates": {
      "ImportEnterpriseRoots": true
    }
  }
}
END

fi


# The following code makes Thunderbird trust the macOS Keychain certificates if Thunderbird is installed.

if [ -d /Applications/Thunderbird.app ] && [ ! -e //Applications/Thunderbird.app/Contents/Resources/distribution/policies.json ]; 

then

mkdir -p /Applications/Thunderbird.app/Contents/Resources/distribution
cat <<END >/Applications/Thunderbird.app/Contents/Resources/distribution/policies.json
{
  "policies": {
    "Certificates": {
      "ImportEnterpriseRoots": true
    }
  }
}
END

fi

#This command removes the temporary SSL Cert file generated at the beginning of the script. It is no longer needed now that it's in the System Keychain.

rm /private/tmp/SSL_Certificate.crt
echo "Success!"